#if !defined(_TREECTRLEX_H_)
#define _TREECTRLEX_H_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// TreeCtrlEx.h : header
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CTreeCtrlEx window

class CDockPane;

class CTreeCtrlEx : public CTreeCtrl
{
protected:
	const int DRAG_DELAY;

	CImageList  m_image;
	CImageList*	m_pDragImage;
	BOOL		m_bLDragging;
	HTREEITEM	m_hitemDrag;
	HTREEITEM   m_hitemDrop;
	HTREEITEM   m_pSelected;
	DWORD       m_dwDragStart;
	UINT		m_nTimerID;
	UINT		m_timerticks;
	UINT		m_nMenuID;
	BOOL		m_bParentDrag;

// Construction
public:
	CTreeCtrlEx();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTreeCtrlEx)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

// Implementation
public:
	void DisableParentDragging( BOOL bEnable );
	virtual BOOL IsFindValid( HTREEITEM );
	virtual HTREEITEM FindItem( CString &str, BOOL bCaseSensitive /*= FALSE */, BOOL bDownDir /*= TRUE */, BOOL bWholeWord /*= FALSE */, HTREEITEM hItem /*= NULL */ );
	HTREEITEM GetPrevItem( HTREEITEM hItem );
	HTREEITEM GetNextItem( HTREEITEM hItem );
	HTREEITEM GetLastItem( HTREEITEM hItem );
	void SetPopupMenuID( UINT uID );
	void EnableDragOperations( BOOL bDrag );
	UINT GetSelectedIcon();
	void SetSelectedIcon( int nIcon );
	HTREEITEM CopyBranch( HTREEITEM htiBranch, HTREEITEM htiNewParent, HTREEITEM htiAfter = TVI_LAST );
	virtual void OnItemCopied(HTREEITEM hItem, HTREEITEM hNewItem );
	HTREEITEM CopyItem( HTREEITEM hItem, HTREEITEM htiNewParent, HTREEITEM htiAfter = TVI_LAST );
	void CollapseAll();
	void CollapseBranch( HTREEITEM hTreeItem);
	void ExpandBranch( HTREEITEM hTreeItem );
	HTREEITEM AddTreeItem(HTREEITEM hParent, CString strText, HTREEITEM hInsAfter = TVI_LAST, int iImage = 0, BOOL bChildren = TRUE);
	void SetTreeStyle( DWORD dwStyle = TVS_HASBUTTONS | TVS_HASLINES | TVS_LINESATROOT );
	void CreateImageList( int nID, int nSize, COLORREF crMask );
	virtual ~CTreeCtrlEx();

	void SetParent(CDockPane* pParent);

	// Generated message map functions
protected:
	BOOL m_bDragEnabled;
	afx_msg void OnContextMenu(CWnd*, CPoint point);
	//{{AFX_MSG(CTreeCtrlEx)
	afx_msg void OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
private:
	CDockPane* m_pParentWnd;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(_TREECTRLEX_H_)
